// $Id: CHostCanDo.cpp,v 1.3 2007/02/08 21:08:23 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * Please note that VST is copyright Steinberg Media GmBh. No challenge is made to any of their trademarks
 * To use this file, you require a copy of the VST SDK, available from www.steinberg.net for free
 */

#include "CHostCanDo.hpp"
#include <Exceptions/CException.hpp>
using Exponent::Exceptions::CException;
using Exponent::Vst::CHostCanDo;

//	===========================================================================
CHostCanDo::CHostCanDo(AudioEffectX *theEffect)
          : m_sendVstEvents(false)
		  , m_sendVstMidiEvent(false)
		  , m_sendVstTimeInfo(false)
		  , m_recieveVstEvents(false)
		  , m_receiveVstMidiEvent(false)
		  , m_receiveVstTimeInfo(false)
		  , m_reportConnectionChanges(false)
		  , m_acceptIOChanges(false)
		  , m_sizeWindow(false)
		  , m_asyncProcessing(false)
		  , m_offline(false)
		  , m_supplyIdle(false)
		  , m_supportShell(false)
		  , m_editFile(false)
		  , m_closeFileSelector(false)
		  , m_startStopProcess(false)
		  , m_hostVersion(0)
{
	this->setFromAudioEffectX(theEffect);
}

//	===========================================================================
CHostCanDo::CHostCanDo()
          : m_sendVstEvents(false)
		  , m_sendVstMidiEvent(false)
		  , m_sendVstTimeInfo(false)
		  , m_recieveVstEvents(false)
		  , m_receiveVstMidiEvent(false)
		  , m_receiveVstTimeInfo(false)
		  , m_reportConnectionChanges(false)
		  , m_acceptIOChanges(false)
		  , m_sizeWindow(false)
		  , m_asyncProcessing(false)
		  , m_offline(false)
		  , m_supplyIdle(false)
		  , m_supportShell(false)
		  , m_editFile(false)
		  , m_closeFileSelector(false)
		  , m_startStopProcess(false)
		  , m_hostVersion(0)
{
	this->initialise();
}

//	===========================================================================
CHostCanDo::~CHostCanDo()
{
	// Nothing to do...
}

//	===========================================================================
void CHostCanDo::initialise()
{
	// First we false all the can dos
	m_sendVstEvents			  = false;
	m_sendVstMidiEvent		  = false;
	m_sendVstTimeInfo		  = false;
	m_recieveVstEvents		  = false;
	m_receiveVstMidiEvent	  = false;
	m_receiveVstTimeInfo	  = false;
	m_reportConnectionChanges = false;
	m_acceptIOChanges		  = false;
	m_sizeWindow			  = false;
	m_asyncProcessing		  = false;
	m_offline				  = false;
	m_supplyIdle			  = false;
	m_supportShell			  = false;
	m_editFile				  = false;
	m_closeFileSelector		  = false;
	m_startStopProcess		  = false;

	// Now the name and developer information
	m_hostName				  = " ";
	m_hostDeveloper			  = " ";
	m_hostVersion			  = 0;
}

//	===========================================================================
void CHostCanDo::setFromAudioEffectX(AudioEffectX *theEffect)
{
	// Check the effect is valid
	if (theEffect == NULL)
	{
		throw CException("Effect is NULL", "CHostCanDo::setFromAudioEffectX(AudioEffectX *)");
	}

	// Initialise ourselves
	this->initialise();

	// Now check if they can be done
	if (theEffect->canHostDo("sendVstEvents"))				m_sendVstEvents			  = true;
	if (theEffect->canHostDo("sendVstMidiEvent"))			m_sendVstMidiEvent		  = true;
	if (theEffect->canHostDo("sendVstTimeInfo"))			m_sendVstTimeInfo		  = true;
	if (theEffect->canHostDo("receiveVstEvents"))			m_recieveVstEvents		  = true;
	if (theEffect->canHostDo("receiveVstMidiEvent"))		m_receiveVstMidiEvent	  = true;
	if (theEffect->canHostDo("receiveVstTimeInfo"))			m_receiveVstTimeInfo	  = true;
	if (theEffect->canHostDo("reportConnectionChanges"))	m_reportConnectionChanges = true;
	if (theEffect->canHostDo("acceptIOChanges"))			m_acceptIOChanges		  = true;
	if (theEffect->canHostDo("sizeWindow"))					m_sizeWindow			  = true;
	if (theEffect->canHostDo("asyncProcessing"))			m_asyncProcessing		  = true;
	if (theEffect->canHostDo("offline"))					m_offline				  = true;
	if (theEffect->canHostDo("supplyIdle"))					m_supplyIdle			  = true;
	if (theEffect->canHostDo("supportShell"))				m_supportShell			  = true;
	if (theEffect->canHostDo("editFile"))					m_editFile				  = true;
	if (theEffect->canHostDo("closeFileSelector"))			m_closeFileSelector		  = true;
	if (theEffect->canHostDo("startStopProcess"))			m_startStopProcess		  = true;

	// Now get the host details
	char text[128];

	// Get host name
	theEffect->getHostProductString(text);
	m_hostName = text;

	// Get developer name
	theEffect->getHostVendorString(text);
	m_hostDeveloper = text;

	// Get teh host version
	m_hostVersion = theEffect->getHostVendorVersion();
}